;; -*- Mode:Common-Lisp; Package:MACTOOLBOX; Base:10; Fonts:(CPTFONT HL10B HL12I CPTFONT CPTFONTB) -*-

;1;; INSTRUCTIONS:*
;1;;     *  Compile and load this file.  For example, if you are reading this in a Zmacs buffer, then use META-Z.*
;1;;     *  Make sure the default TB Server is running, enter *(tb:launch-default-tb-server t)1 in a*
;1;;         listener.  (You will have to click on the microExplorer window to reselect it after the launch.)*
;1;;     * Shrink the microExplorer window until it occupies the lower half of the screen leaving the upper half*
;1;;         free for the window we are about to create.*
;1;;     * Enter *(tb:example-shell)1 in a listener*
;1;;     * Click on the "Play Window" to select the TB Server application, and play!*
;1;;     * This Play Window can do exactly three things:*
;1;;        -  It implements a "mouse pencil" (i.e., it draws a line on the window as long as you hold the mouse*
;1;;           button down); *
;1;;        -  It beeps at you if you click on the "About Example Shell..." item in the Apple menu of the*
;1;;           Menu Bar; and *
;1;;        -  It will quit gracefully if you click on the "Quit" item in the File menu of the Menu Bar.*
;1;;     * After you have "Quit" out of the Play Window, you will have to click on the microExplorer window to*
;1;;        reselect it.*

(defvar *FileMenuID* 11)
(defvar FileMenu)
(defvar AppleMenu)
(defvar *AppleMenuID* 10)


(defun 4EXAMPLE-SHELL *()
  "2This is a trivial Macintosh application  which creates a window labelled
'Play Window' which can do exactly three things:
   * It implements a 'mouse pencil' (i.e., it draws a line on the window as long
      as you hold the mouse button down); 
   *  It beeps at you if you click on the 'About Example Shell...*'2 item in the
      Apple menu of the Menu Bar; and
   *  It will quit gracefully if you click on the *'2Quit*'2 item in the File menu of
      the Menu Bar.*"
  (declare (values ignore))

  ;1; PROGRAMMING NOTE:  At this point in most Macintosh applications you will see a standard set of calls*
  ;1; to various initialization functions such as InitGraf, InitFonts, InitWindows, InitMenus, TEInit, and*
  ;1; InitDialogs.  You should 2NOT * include calls to these traps in your Macintosh applications on the*
  ;1; microExplorer since they are done for you when the Toolbox Server is started up on the Macintosh *
  ;1; side.  As a* 1reminder, there are comments in the manual to the effect that you don't have to execute*
  ;1; these traps since all basic initializations are done for you.*

  (Setup-shell-menu-bar)
  ;1; PROGRAMMING NOTE:  Many of the things you have come to take for granted about the Macintosh*
  ;1; environment appear only through the cooperation of the application writers.  For example, you--*
  ;1; the Macintosh application writer--must establish which menus go in the Menu Bar, in which order,*
  ;1; and with what names.  Furthermore, you must load up those menus.  For example, if you don't*
  ;1; explicitly load the desk accessories into the Apple Menu, then your user won't have access to any*
  ;1; accessory while running your application.  Therefore, some version of this SETUP-SHELL-MENU-BAR*
  ;1; function is virtually a standard feature of all Macintosh applictions.*
  
  (Initialize-Shell-Window)			  ;1Show a default window*
  (!InitCursor)
  (let ((event (make-instance 'EventRecord)))	  ;1 always the event being processed*
    (unwind-protect
	;1; PROGRAMMING NOTE:* 1 Regardless of whether the exit is normal or abnormal, the*
	;1; UNWIND-PROTECT guarantees that a* 1piece of cleanup code, the SHELL-CLEANUP function*
	;1; in this case, will START executing...but the clean up code is NOT guaranteed to complete.  If*
	;1; the cleanup code itself gets errors (or an* 1impatient user presses CTRL-ABORT), then the*
	;1; clean* 1up code will not complete.*

	(catch 'EVENT-LOOP-EXIT
	  ;1; PROGRAMMING NOTE:* 1The proper way to exit from the infinite Main Event Loop below is to*
	  ;1; throw to 'EVENT-LOOP-EXIT.* 1The value expression of the THROW form will be returned as*
	  ;1; the value of the shell.*

	  ;1; MAIN EVENT LOOP*
	  (!FlushEvents !everyEvent 0)		  ;1Empty the event queue before we start*
	  (select-application "3tbserver*")
	  (error-restart-loop (error "3Restart Example Shell Main Event Loop.*")
	    ;1; IMPLEMENTATION NOTE:* 1Things such as main event loop deserve extra consideration:*
	    ;1; You don't want them to* 1halt unnecessarily and you want to get them restarted easily if*
	    ;1; they do stop.*
	    ;1;*
	    ;1; Under normal circumstances ERROR-RESTART-LOOP acts as a LOOP form--a simple*
	    ;1; infinite loop.  However, if one of the specified conditions (*error1, in this case) is signaled*
	    ;1; within the loop, the user is presented with a proceed option to restart the loop at the top.*
	    ;1; The wording of the proceed option is the string argument to ERROR-RESTART-LOOP.*
	    
	    (catch 'EVENT-LOOP-TOP
	      ;1; PROGRAMMING NOTE:* 1The proper way to abnormally terminate the processing of the*

	      ;1; to release any objects* 1created so far during the processing of the aborted event and*
	      ;1; then THROW to* 1'EVENT-LOOP-TOP.*

	      (when (!WaitNextEvent !everyEvent event 0 !nilrgn)
		;1; then this is an event AND it is an event we are supposed to handle*
	1                  *;1; (it is possible to get events which we AREN'T supposed to process)*
	      
	1                  *;1; IMPLEMENTATION NOTE:* 1The 2sleep* argument to !WaitNextEvent (a *01 in the above*
		;1; call) places an upper limit* 1on how long !WaitNextEvent will wait before returning.  It*
		;1; is measured in 1/60-ths of3 *a second.  A value of zero says "Don't sleep, but return*
		;1; to me as frequently as you3 *can."*
		;1;*
	1                  *;1; The *region1 argument  can be used to avoid being* 1bother by uninteresting mouse*
		;1; events.  When defaulted to *!nilRgn1 as shown* 1here, you see all mouse events.  If*
		;1; a region is specified, then you will only see* 1mouse events when the mouse moves*
		;1; outside the specified region.*

		(case (the fixnum (send event :what)) ;1dispatch on event type*
		1    *;1; IMPLEMENTATION NOTE:* 1Explicitly declaring the event type to be a fixnum*
		  ;1; allows the compiler to use a* 1microcoded DISPATCH instruction rather than a*
		  ;1; series of compare and branches.* 1Of course, depending upon what else is going*
		  ;1; on inside the CASE statement,this minor efficiency hack may be lost in the noise.*
		1    *;1;*
		1    *;1; Given that a DISPATCH instruction is going to be used to implement this CASE*
		1    *;1; statement anyway, there is no particular advantage or disadvantage in*
		1    *;1; enumerating all possible events as shown below.  If you want a more compact*
		1    *;1; notation, delete all ignored clauses AND the OTHERWISE clause so that ignored*
		1    *;1; events merely fall though.*
		1    *;1;*
		1    *;1; Using (IGNORE) for the body of unused clauses is the same as using NIL.*
		1    *;1; However, (IGNORE) has the minor documentation characteristic that it assures*
		1    *;1; reader that you did truly want to ignore the case and have not simply forgotten*
		1    *;1; about it.*
		1    *;1;*
		1    *;1; The *#.1 prefix in needed for each of the symbolic constants because CASE does *
		1    *;1; not evaluate its arguments.  It would see *!nullEvent1 (i.e., no prefix) as a symbol *
		1    *;1; which obviously doesn't match the fixnum event code.  However,  it will see*
		1    *;1; *#.nullEvent1 as the number *01 which is what we want.  Without the *#.1 prefix, we*
		1    *;1; would have had to use a COND statement where each claused looked like*
		1    *;1; *((= !nullEvent event-code) ...)1...which is a lot more clumsy.*
		
		  (#.!nullEvent   (ignore))
		  (#.!mouseDown   (Shell-mouseDown-Handler event))
		  (#.!mouseUp     (ignore))
		  ((#.!keyDown			  ;1!autoKey event (key held down until it*
		    #.!autoKey)   (ignore))	1     *;1   repeats) is usually treated as !keyDown*
		  (#.!keyUp       (ignore))
		  (#.!updateEvt   (ignore))	1     *;1a window needs to be refeshed*
		  (#.!diskEvt     (ignore))	  ;1a disk was inserted*
		  (#.!activateEvt (ignore))	  ;1a window has been selected*
		  (#.!networkEvt  (ignore))
		  (#.!driverEvt   (ignore))
		  ((#.!app1Evt			  ;1these events originate in the application*
		    #.!app2Evt			  ;1   rather than in system by application *
		    #.!app3Evt)	  (ignore))	  ;1   calls to !PostEvent.*
		    ;1; NOTE:  *!app4Evt1 is also defined, but it is reserved  for the MultiFinder*
		  (otherwise (!Sysbeep 5))	  ;1tell us if we've forgotten something*
		1     *);1;case*
		);1;when*
	      );1;catch EVENT-LOOP-TOP*
	    
	    ;1; A THROW to 'EVENT-LOOP-TOP will end up here, at the bottom of the main event loop.*
	    ;1; Also, choosing the proceed type of "Restart Example Shell Main Event Loop" from the*
	    ;1; error handler will end up here too.*
	    );1;error-restart-loop*
	  );1;catch EVENT-LOOP-EXIT*
      
1             *;1; a THROW to 'EVENT-LOOP-EXIT will end up here, immediately outside the main event loop*
      (Shell-Cleanup)
1              *);1;unwind-protect*
    );1;let*
  );1;example-shell*


;1;;; 4AN ALTERNATIVE IMPLEMENTATION**

;1;; The file SYS:PUBLIC-MX; TOOLBOX-MACROS contains the LOOP-ON-EVENT macro which subsumes*
;1;; all of the "Good Housekeeping" choses of the above version of EXAMPLE-SHELL (plus a few others)*
;1;; which surround the CASE statement clauses that do the dispatching on each event.  See*
;1;; LOOP-ON-EVENT's documentation string for details.*
;1;;*
;1;; As an example of how this macro can simplify your code, the function EXAMPLE-SHELL is reproduced*
;1;; below (without the voluminous comments and do-nothing clauses) using LOOP-ON-EVENT rather than*
;1;; the discrete code:*
;1;;*
;1;;*	(defun 4EXAMPLE-SHELL-2 *()
;1;;*	  (declare (values ignore))
;1;;*	  (Setup-shell-menu-bar)
;1;;*	  (Initialize-Shell-Window)
;1;;*	  (!InitCursor)
;1;;*	  (loop-on-event ()
;1;;*	    (#.!mouseDown (Shell-mouseDown-Handler event))
;1;;*	    (otherwise    (ignore))
;1;;*	    (:cleanup     (Shell-Cleanup))))



(defun 4Initialize-Shell-Window *()
  "2make a window*"
  (make-instance 'tb:window :title "Play Window")
  );1;Initialize-Shell-Window*


(defun 4SHELL-MENU-CREATE *(ID title data)
  "2makes a menu and returns a handle to it*"
  (let ((new-menu (make-instance 'menuinfo)))
    (setf (send new-menu :handle) (send (!NewMenu ID title) :handle))
    (!AppendMenu new-Menu data)
    (!InsertMenu new-Menu 0)
    new-Menu)
  );1;shell-menu-create*


(defun 4SETUP-SHELL-MENU-BAR *()
  "2sets up Menu Bar for the Shell application*"
  (!ClearMenuBar)				  ;1start with a clean slate (so to speak)*
  (setf AppleMenu				  ;1start definition of the Apple Menu*
	(Shell-menu-create *AppleMenuID* (string (code-char !appleMark))
		     "About 3Example* Shell...;(-"))
  ;1; IMPLEMENTATION NOTE:  The string in the above form is really the menu item list written in a small*
  ;1; item-description language which is eventually used by !AppendMenu.*
  ;1;    * each menu item is separated by a semicolon or a return character (therefore, we have two items*
  ;1;       specified in the above string because there is one semicolon)*
  ;1;    * a hyphen causes a dotted line to be drawn across the width of the menu as a visual separator*
  ;1;       (therefore, we will have the "About Example Shell..." item followed by a dotted line)*
  ;1;    * an open parnethesis "disables" the next item (therefore, our dotted line will not be mouseable...*
  ;1;       which is reasonable)*
  ;1;*
  ;1; Other features not used here include specifying an icon for the item, specifying a keyboard*
  ;1; equivalent for the item, placing a check mark by the item, and specifying special text styles for the*
  ;1; item such as bold, italic, underline, shadow, etc.  [see I-348 in 2Inside Macintosh*]*

  (!AddResMenu AppleMenu "DRVR")		1     *;1 add Desk Accessories to Apple Menu*
  ;1; IMPLEMENTATION NOTE:  While you are responsible for establishing the Menu Bar and everything*
  ;1; in it, that isn't to say that you can't get some help.  The above form takes the desk accessories which*
  ;1; are predefined in the *"DRVR"1 resource and appends them to the menu (which was initialized above*
  ;1; to contain just the "About Example Shell..." item).*
  
  (setf FileMenu (shell-menu-create *filemenuID* "File" "Quit")) ;1add File menu*
  ;1; this form defines a menu named *"File"1 with one item, *"Quit"1.*

  (!DrawMenuBar)				1     *;1 Draw the complete Menu Bar*
  );1;setup-shell-menu-bar*





(defun 4Shell-mouseDown-Handler *(event)
  "2Handles !mouseDown events*"
  ;1; PROGRAMMING NOTE:* 1A mouse handler is most interested in the 2point* where the mouse was clicked*
  ;1; and which window that* 1point was in.  The location of the point is returned in the event record and can*
  ;1; be explicitly extracted* 1as individual H and V coordinates.*
  ;1;*
  ;1; However, the Toolbox Interface flavor EVENTRECORD has the flavor POINT as a mixin.  Therefore,*
  ;1; we may simply use an eventrecord instance  whereever a point instance is needed.  In particular,*
  ;1; FINDWINDOW is nominally documented to take a point instance as an argument, but it is more*
  ;1; convenient--and just as valid--to pass it the original event record which started everything off.*
  
  (multiple-value-bind (partcode window)
      (FindWindow event)
      ;1; given a point, *event1, which in this case represents where the mouse was clicked, FindWindow*
      ;1;determines what part of what window the point is in and returns both pieces of information*
      ;1; as *partcode1 and *window1.*
    
    (case (the fixnum partcode)			  ;1dispatch on where the mouse was clicked*
      (#.!inDesk      (ignore))			  ;1 somewhere on the background desktop*
      (#.!inMenuBar   (shell-inmenubar-handler event))  ;1bar across top of screen*
      (#.!inSysWindow (!SystemClick event window))
      (#.!inContent   (!SysBeep 1)		  ;1 somewhere inside the window*
		      (send event :lineto)	  ;1 draw first line from upper left corner*
		      (let ((point (make-instance 'point)))
		        (loop
			  (when (not (!button)) (return)) ;1loop until button released*
			  ;1; otherwise, button still down, so track it*
			  (!getmouse point)
			  (send point :lineto)))) ;1 "draw" with the mouse in real-time*
      (#.!inDrag      (ignore))			  ;1 in bar across the top of a window*
      (#.!inGrow      (ignore))			  ;1 in box in lower right corner*
      (#.!inGoAway    (ignore))			  ;1 in box in upper left corner*
      ((#.!inZoomIn				  ;1 in box in upper right corner*
	#.!inZoomOut) (ignore))
      (otherwise      (!sysbeep 1))		  ;1 beep if we've forgotten anything*
      );1;case*			       
    );1;multiple-value-bind*
  );1;mouse-down-handler*
  

(defun 4SHELL-INMENUBAR-HANDLER *(event)
  "2Handles mousedown in menubar events*"
  (declare (values ignore))
  (multiple-value-bind (menu-id item-id)
      (!MenuSelect event)
      ;1; given a point, *event1, which in this case represents where the mouse was clicked, !MenuSelect*
      ;1; determines the integer menu ID and the integer item ID within that menu where the point lies and*
      ;1; returns both pieces of information as *menu-id1 and *item-id1.  You specified those menus so you*
      ;1; are responsible for remembering what the menu IDs and item IDs mean.*
    
    (!hilitemenu 0)				  ;1we've seen it, so turn off highlighting*
    (cond ((= menu-id *applemenuid*)		  ;1dispatch on the menu ID*
	1       *;1; case of apple in the menu bar*
	   (shell-applemenu-handler item-ID))
	  
	  ((= menu-id *filemenuid*)
	1       *;1; case of File in the menu bar*
	   (Shell-FileMenu-Handler item-ID))
	  
	1     *(t ;1;case of anything else in menu bar*
	    (ignore))
	1     *);1;cond*
    );1; multiple-value-bind*
  );1;shell-inmenubar-handler*

 
(defun 4SHELL-APPLEMENU-HANDLER *(item-ID)
  "2handles mousedown in apple menu of menu bar event*"
  (cond ((= item-id 1)
	 ;1; case of clicked on "About Simple Shell..."*
         (about-shell))
	
	;1; NOTE:  ITEM-ID = 2 is the unselectable line separating the "About Simple Shell..." entry from*
	;1; everything that follows (which happens to be all those desk accessories we added from a*
	;1; resource.*

        ((>= item-ID 3)
	 ;1; case of clicked on some desk accessory*
	 (!opendeskacc (getitem applemenu item-id)))	  ;1 get its name and open it*

	(t (warn "3~%SHELL-APPLEMENU-HANDLER received an illegal item-id of ~s.*"
		 item-id)
	   (throw 'EVENT-TOOP-TOP nil))
	;1; IMPLEMENTATION NOTE:* 1This sort of error isn't really a big enough problem to warrant a*
	;1; THROW to 'EVENT-LOOP-TOP* 1because, in this particular case, quietly returning from this*
	;1; function* 1would have done the* 1same thing.  You would usually use a THROW in cases where it*
	;1; is* 1impossible or unsafe to* 1continue with the current processing so that you must deliberately*
	;1; skip everything else* 1that would normally have gone into completeing the current event.*
	
	);1;cond*
  );1;shell-applemenu-handler*


(defun 4SHELL-FILEMENU-HANDLER *(itemID)
  "2Handle menu items like NEW, CLOSE & QUIT*"
  (when (= itemID 1)
    (throw 'EVENT-LOOP-EXIT 'QUIT)))


(defun @ABOUT4-*SHELL *()
  "2The About... Apple Menu entry for this simple shell*"
  (!sysbeep 1))


(defun 4SHELL-CLEANUP *()
  (loop
    (when (not (!frontwindow)) (return))	  ;1 loop until no front window*
    (send (!frontwindow) :dispose))		  ;1   disposing of each window we find*
  (!clearmenubar)
  (!drawmenubar)
  (select-application)
  );1;Shell-Cleanup











